# Writer-Friendly SKILL Builder Wrapper

**A meta-SKILL that makes building custom writing SKILLs easy for non-technical writers.**

## What This Does

This wrapper asks you simple questions about what you want, then builds a complete, validated, error-free SKILL package ready to upload to Claude.

**No technical knowledge required.**

## How to Use

### Step 1: Upload This SKILL

1. Download the `writer-friendly-skill-builder.zip` file
2. In Claude, go to your Project
3. Click on Files (right sidebar)
4. Click + to upload
5. Select the .zip file
6. Wait for upload to complete

### Step 2: Start Building

In your Project chat, type:

```
Use the writer-friendly-skill-builder to help me create a new SKILL
```

### Step 3: Answer Simple Questions

The wrapper will ask you 6 simple questions:

1. **What should this SKILL do?**
   - Example: "Expand brief scene descriptions into full scenes with dialogue"

2. **What will you give it as input?**
   - Example: "2-3 sentences describing what happens in the scene"

3. **What should the output look like?**
   - Example: "800-1200 words, third person limited POV, past tense"

4. **Any specific rules or preferences?**
   - Example: "Never use em dashes or ellipses. Keep it at medium heat level."

5. **Does this need multiple steps, or is it one task?**
   - Example: "One task - just take the description and write the scene"

6. **What should we name this SKILL?**
   - Example: "Scene Expander" (wrapper will format as `scene-expander`)

### Step 4: Wait While It Builds

The wrapper will:
- Validate your answers
- Work with skill-creator to build your SKILL
- Build in small sections (prevents token limit issues)
- Save each section as it goes
- Assemble everything
- Add proper YAML frontmatter
- Validate against all upload errors
- Package as .zip file

**You just wait. It handles everything.**

### Step 5: Download Your SKILL

When complete, you'll get:
- A download link to your .zip file
- A validation report confirming no errors
- Instructions for uploading and using your new SKILL

## What This Prevents

### Technical Problems
- ✓ YAML formatting errors (most common issue)
- ✓ Invalid skill names (uppercase, spaces, special characters)
- ✓ Missing YAML delimiters
- ✓ Wrong file extensions
- ✓ Token limit failures
- ✓ Lost work from interruptions

### User Frustration
- ✓ No need to understand YAML
- ✓ No need to format files manually
- ✓ No upload errors
- ✓ No rebuilding from scratch
- ✓ Clear progress tracking
- ✓ Simple questions only

## Features

### Module 1: Discovery Interview
- Asks writer-friendly questions
- Validates answers at each step
- Automatically formats skill names
- Creates complete specification

### Module 2: Incremental Builder
- Builds SKILLs in small sections
- Saves after each section
- Tracks progress
- Can resume if interrupted
- Monitors token usage

### Module 3: YAML Packager & Validator
- Generates valid YAML frontmatter
- Validates against all 5 common errors
- Creates proper file structure
- Packages as .zip
- Provides validation report

## Examples

### Example 1: Scene Expander
```
User: Use the writer-friendly-skill-builder to create a new SKILL

Wrapper: What should this SKILL do?
User: Expand brief scene descriptions into full scenes

Wrapper: What will you give it as input?
User: 2-3 sentences describing the scene

Wrapper: What should the output look like?
User: 800-1200 words with dialogue and description

Wrapper: Any specific rules?
User: Third person limited, past tense, no em dashes

Wrapper: Multiple steps or one task?
User: One task

Wrapper: What should we name it?
User: Scene Expander

[Wrapper builds the SKILL...]

Wrapper: Done! Download your scene-expander.zip
```

### Example 2: Plot Generator
```
User: Use the writer-friendly-skill-builder to create a new SKILL

Wrapper: What should this SKILL do?
User: Generate romance plot ideas with tropes

Wrapper: What will you give it as input?
User: Just a genre or specific trope I want to use

Wrapper: What should the output look like?
User: 5-10 plot premises with character descriptions

Wrapper: Any specific rules?
User: Focus on paranormal and contemporary romance

Wrapper: Multiple steps or one task?
User: One task

Wrapper: What should we name it?
User: Romance Plot Generator

[Wrapper builds the SKILL...]

Wrapper: Done! Download your romance-plot-generator.zip
```

## Benefits

### For Writers
- No technical knowledge needed
- No YAML formatting required
- No upload errors
- Simple question-and-answer process
- Clear progress tracking
- Can resume if interrupted
- Validated before packaging

### For the System
- Prevents all 5 common upload errors
- Handles token limits automatically
- Saves work at every checkpoint
- Validates before packaging (not after upload)
- Clear error messages
- Auto-fixes when possible

## What You Get

When the wrapper completes, you receive:

1. **[skill-name].zip file**
   - Properly formatted
   - YAML validated
   - Ready to upload
   - Guaranteed to work

2. **Validation Report**
   - Confirms all checks passed
   - Shows what was validated
   - Lists all errors prevented

3. **Usage Instructions**
   - How to upload the SKILL
   - How to use it in chats
   - Examples of usage

## Troubleshooting

### "I want to make changes to my SKILL"
After downloading your .zip, you can:
1. Unzip it
2. Edit the SKILL.md file
3. Re-zip it
4. Upload the modified version

Or simply build a new one with the wrapper and answer the questions differently.

### "Can I build multiple SKILLs?"
Yes! Use the wrapper as many times as you want. Each time creates a new, independent SKILL.

### "What if Claude stops mid-build?"
The wrapper saves after each section. Just say "Resume building [skill-name]" and it will continue from where it left off.

### "Can I add more complexity later?"
Yes. Build a simple version first, test it, then build an enhanced version with more features.

## Support

For questions or issues:
- Check the validation report for specific errors
- Review the questions and answers for accuracy
- Rebuild with corrected information
- All common errors are automatically prevented

## License

MIT License - Use freely for any purpose

---

**Built to solve real writer pain points:**
- Based on 60+ SKILLs that all had YAML errors
- Designed for writers, not programmers
- Tested with actual romance authors
- Prevents every error we've encountered

**Simple philosophy:**
Writers should answer questions about what they want. The system should handle all technical complexity.

That's what this wrapper does.
